% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.recombine}
\alias{bursts.recombine}
\title{Combine bursts into one recording (with obvious spaces between them).}
\usage{
bursts.recombine(bursts)
}
\arguments{
\item{bursts}{The list of all bursts}
}
\value{
The segment containing all bursts.
}
\description{
From a list of segments, return the concatenated  segment containing all bursts. Inverse of functions like bursts.defined_by_tcrit
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

# This is a single segment!
record <- bursts.recombine(bursts)

# Which means you can do stuff like this
open_dwells <- segment.open_dwells(bursts.recombine(bursts))

}
