% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scdf.R
\name{scdf}
\alias{scdf}
\alias{scdf-class}
\alias{as.scdf}
\title{Single case data frame}
\usage{
scdf(
  ...,
  B_start = NULL,
  phase_starts = NULL,
  phase_design = NULL,
  name = NULL,
  dvar = "values",
  pvar = "phase",
  mvar = "mt"
)
}
\arguments{
\item{...}{One or more vectors representing measurement variables. See the
\emph{Details} section.}

\item{B_start}{The first measurement point of phase B (simple coding; only
applicable if the design follows a strict AB pattern).}

\item{phase_starts}{A named vector defining the label and measurement time of
each phase start. For example: \code{phase_starts = c(A1 = 1, B1 = 6, A2 = 14, B2 = 19)}.}

\item{phase_design}{A named vector defining the length and label of each
phase. For example: \code{phase_design = c(A1 = 10, B1 = 10, A2 = 10, B2 = 10)}.}

\item{name}{Optional name for the case.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}
}
\value{
Returns a single-case data frame \code{scdf} suitable for all functions in
the \code{scan} package.
}
\description{
\code{scdf()} is the constructor for objects of class \code{scdf}. It stores data from
single-case studies with one or more cases in a structured format suitable
for analysis with the \code{scan} package.
}
\details{
If no variable matching the name of the dependent variable is
provided (the default name is \code{values}, which can be changed via the \code{dvar}
argument), and the first provided variable is unnamed, that variable will
be interpreted as the dependent variable.

If no measurement-time variable is provided (default name \code{mt},
configurable via the \code{mvar} argument), measurement times are automatically
defined as a sequence \verb{(1, 2, 3, ..., n)}.

If the dependent variable is a \strong{named vector}, the names will be used to
define a phase design. For example, \code{values = c(A = 2, 3, 5, 4, 3, B = 6, 5, 4, 3)} will be interpreted as an AB phase design with five measurements
in phase A and four in phase B.

If a vector matching the name of the phase variable is provided, it will be
used to define the phase design directly.
}
\examples{
## Scores on a letter naming task were collected on eleven days in a row.
## The intervention started after the fifth measurement,
## so the first B phase measurement was 6 (B_start = 6).
klaas <- scdf(
  c(5, 7, 8, 5, 7, 12, 16, 18, 15, 14, 19),
  B_start = 6, name = "Klaas"
)
describe(klaas)

# Alternative: using named vector
klaas <- scdf(
  c(A = 5, 7, 8, 5, 7, B = 12, 16, 18, 15, 14, 19),
  name = "Klaas"
)

# Alternative: using phase_design
klaas <- scdf(
  c(5, 7, 8, 5, 7, 12, 16, 18, 15, 14, 19),
  phase_design = c(A = 5, B = 6), name = "Klaas"
)

# Alternative: using phase_starts
klaas <- scdf(
  c(5, 7, 8, 5, 7, 12, 16, 18, 15, 14, 19),
  phase_starts = c(A = 1, B = 7), name = "Klaas"
)

## Unfortunately in a similar study there were no data collected on
## days 3 and 9. Use NA to pass them to the function:
emmi <- scdf(c(5, 7, NA, 5, 7, 12, 16, 18, NA, 14, 19),
  phase_design = c(A = 5, B = 6), name = "Emmi"
)
describe(emmi)

## In a MBD over three cases, data were collected eleven days in a row.
## Intervention starting points differ between subjects as they were
## randomly assigned. The three SCDFs are then combined in a list for
## further conjoined analyses.
charlotte <- scdf(c(A = 5, 7, 10, 5, 12, B = 7, 10, 18, 15, 14, 19))
theresa <- scdf(c(A = 3, 4, 3, 5, B = 7, 4, 7, 9, 8, 10, 12))
tonia <- scdf(c(A = 9, 8, 8, 7, 5, 7, B = 6, 14, 15, 12, 16))
mbd <- c(charlotte, theresa, tonia)
names(mbd) <- c("Charlotte", "Theresa", "Tonia")
overlap(mbd)

## In a classroom-based intervention it was not possible to measure outcomes
## every day, but only on schooldays. The sequence of measurements is passed
## to the package by using a vector of measurement times.
frida <- scdf(
  c(A = 3, 2, 4, 2, 2, 3, 5, 6, B = 8, 10, 8, 12, 14, 13, 12),
  mt = c(1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18)
)
summary(frida)
describe(frida)

## example with two independent variables and four phases
jim <- scdf(
  zvt = c(47, 58, 76, 63, 71, 59, 64, 69, 72, 77, 76, 73),
  d2 = c(131, 134, 141, 141, 140, 140, 138, 140, 141, 140, 138, 140),
  phase_design = c(A1 = 3, B1 = 3, A2 = 3, B2 = 3), dvar = "zvt"
)
overlap(jim, phases = list(c("A1", "A2"), c("B1", "B2")))

}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{print.sc_outlier}()},
\code{\link{ranks}()},
\code{\link{rescale}()},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
