% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment_methods.R
\name{align_raw}
\alias{align_raw}
\alias{dda1}
\alias{dda2}
\alias{lra}
\alias{lra2}
\title{Scale Alignment Methods}
\usage{
dda1(
  multi_pars,
  uni_pars,
  itemtype,
  item_ind,
  dim_ind_i,
  refdim = 1,
  alpha = 1
)

dda2(
  multi_pars,
  uni_pars,
  itemtype,
  item_ind,
  dim_ind_i,
  refdim = 1,
  alpha = 1
)

lra(
  multi_pars,
  itemtype,
  ss,
  nobs,
  ncats,
  thresh_m,
  item_ind,
  dim_ind_i,
  refdim = 1,
  alpha = 1
)

lra2(dat, multi_pars, itemtype, item_ind, dim_ind_i, refdim = 1, alpha = 1)
}
\arguments{
\item{multi_pars}{Vector of estimated multidimensional item parameters, to
be rescaled.}

\item{uni_pars}{Vector of estimated unidimensional item parameters, must be
in the same order as multi_pars.}

\item{itemtype}{Item type: "1PL", "PCM", or "PCM2", see \link{align}.}

\item{item_ind}{Vector with one element for each parameter indicating which
item each parameter is associated with.}

\item{dim_ind_i}{Vector with one element for each item indicating which
dimension each item is associated with.}

\item{refdim}{Which is the reference dimension (unchanged during alignment)}

\item{alpha}{Vector of dimension steepnesses (often set equal to 1).
Recycled if alpha is of length 1.}

\item{ss}{Item sufficient statistics as proportions of examinees who reach
each step, see \link{align}. Should be of the same length as multi_pars.}

\item{nobs}{Number of observed (non-missing) data points for each item.}

\item{ncats}{Number of response categories for each item.}

\item{thresh_m}{Vector of Thurstone thresholds. Should be the same length as
multi_pars and ss.}

\item{dat}{Data set with items as columns and examinees as rows. This data
set must be the same data set used to estimate item parameters.}
}
\value{
List with the following elements
\item{rhat}{Vector of estimated scaling parameters \eqn{r}}
\item{shat}{Vector of estimated shift parameters \eqn{s}}
\item{alphatilde}{Vector of transformed dimension steepnesses}
\item{new_pars}{Vector of transformed (i.e., aligned) item parameters}
\item{thresh}{Vector of aligned Thurstone thresholds}
}
\description{
Apply scale alignment methods to sets of item parameters and other
model information provided by the user. These functions may be used
to apply scale alignment to output from other item parameter estimation
programs such as ConQuest. Note that dda1 and dda2 both require user-provided
unidimensional and multidimensional item parameters.The lrafunction requires
user-provided sufficient statistics, thresholds, and the number of
observations and response categories per item. The function lra2 is a wrapper
for lra that computes some needed quantities from a user-provided data set.
}
\details{
See \link{align}.
}
