% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ontoMultiMinimal}
\alias{ontoMultiMinimal}
\title{get the minimal ontology tree of a list of seurat objects by reducing descendant terms to ancestor terms
return a named list of seurat objects with meta.data[["cell_ontology_base"]] storing the reduced ontology annotation}
\usage{
ontoMultiMinimal(obj_list, ont, anno_col = "cell_ontology_base", onto_id_col)
}
\arguments{
\item{obj_list}{a named list of seurat objects}

\item{ont}{ontologyIndex object}

\item{anno_col}{the cell ontology text annotation column name}

\item{onto_id_col}{if also have ontology id column for direct mapping}
}
\value{
a named list of seurat objects with meta.data[["cell_ontology_base"]]
}
\description{
get the minimal ontology tree of a list of seurat objects by reducing descendant terms to ancestor terms
return a named list of seurat objects with meta.data[["cell_ontology_base"]] storing the reduced ontology annotation
}
\examples{
\dontrun{
ontoMultiMinimal(seurat_obj_list, ont, "cell_ontology_base", 'ontology_id')
}
}
