% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prop_associations.R
\name{get_subclusters}
\alias{get_subclusters}
\title{Perform leiden subclustering to get cell subtypes}
\usage{
get_subclusters(
  container,
  ctype,
  resolution,
  min_cells_group = 50,
  small_clust_action = "merge"
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ctype}{character The cell type to do subclustering for}

\item{resolution}{numeric The leiden resolution to use}

\item{min_cells_group}{numeric The minimum allowable cluster size (default=50)}

\item{small_clust_action}{character Either 'remove' to remove subclusters or
'merge' to merge clusters below min_cells_group threshold to the nearest cluster
above the size threshold (default='merge')}
}
\value{
A vector of cell subclusters.
}
\description{
Perform leiden subclustering to get cell subtypes
}
