% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_tensor.R
\name{form_tensor}
\alias{form_tensor}
\title{Form the pseudobulk tensor as preparation for running the tensor decomposition.}
\usage{
form_tensor(
  container,
  donor_min_cells = 5,
  norm_method = "trim",
  scale_factor = 10000,
  vargenes_method = "norm_var",
  vargenes_thresh = 500,
  batch_var = NULL,
  scale_var = TRUE,
  var_scale_power = 0.5,
  custom_genes = NULL,
  verbose = TRUE
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{donor_min_cells}{numeric Minimum threshold for number of cells per
donor (default=5)}

\item{norm_method}{character The normalization method to use on the pseudobulked
count data. Set to 'regular' to do standard normalization of dividing by
library size. Set to 'trim' to use edgeR trim-mean normalization, whereby counts
are divided by library size times a normalization factor. (default='trim')}

\item{scale_factor}{numeric The number that gets multiplied by fractional counts
during normalization of the pseudobulked data (default=10000)}

\item{vargenes_method}{character The method by which to select highly variable
genes from each cell type. Set to 'anova' to select genes by anova. Set to
'norm_var' to select the top genes by normalized variance or 'norm_var_pvals'
to select genes by significance of their overdispersion (default='norm_var')}

\item{vargenes_thresh}{numeric The threshold to use in variable gene selection.
For 'anova' and 'norm_var_pvals' this should be a p-value threshold. For 'norm_var' this
should be the number of most variably expressed genes to select from each cell
type (default=500)}

\item{batch_var}{character A batch variable from metadata to remove (default=NULL)}

\item{scale_var}{logical TRUE to scale the gene expression variance across donors
for each cell type. If FALSE then all genes are scaled to unit variance across
donors for each cell type. (default=TRUE)}

\item{var_scale_power}{numeric Exponent of normalized variance that is
used for variance scaling. Variance for each gene
is initially set to unit variance across donors (for a given cell type).
Variance for each gene is then scaled by multiplying the unit scaled values
by each gene's normalized variance (where the effect of the mean-variance
dependence is taken into account) to the exponent specified here.
If NULL, uses var_scale_power from container$experiment_params. (default=.5)}

\item{custom_genes}{character A vector of genes to include in the tensor.
Overrides the default gene selection if not NULL. (default=NULL)}

\item{verbose}{logical Set to TRUE to print out progress (default=TRUE)}
}
\value{
The project container with a list of tensor data added in the
container$tensor_data slot.
}
\description{
Form the pseudobulk tensor as preparation for running the tensor decomposition.
}
\examples{
test_container <- form_tensor(test_container, donor_min_cells=0,
norm_method='trim', scale_factor=10000, vargenes_method='norm_var', vargenes_thresh=500,
scale_var = TRUE, var_scale_power = 1.5)
}
