% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.estimator.R
\name{cluster.estimator}
\alias{cluster.estimator}
\title{Parameter estimation for cluster samples}
\usage{
cluster.estimator(
  N,
  data,
  estimator = c("total", "mean", "proportion", "class total"),
  replace = FALSE,
  alpha
)
}
\arguments{
\item{N}{Number of clusters for the population}

\item{data}{Cluster sample}

\item{estimator}{Estimator to compute. Can be one of "total", "mean", "proportion", "class total". Default is "total".}

\item{replace}{Whether the sample to be taken can have repeated instances or not.}

\item{alpha}{Optional value to calculate estimation error and build 1-alpha}
}
\value{
A list containing different interest values:
 \itemize{
 \item estimator
 \item variance
 \item sampling.error
 \item estimation.error
 \item confint
}
}
\description{
Estimates parameters with optional confidence interval for clustered data
of similar cluster size.
}
\details{
This function admits both grouped and non-grouped by cluster data.\cr
Non-grouped data must have interest variable data in the first column and cluster
name each individual belongs to in the last column.\cr
Grouped by cluster data must have interest variable data in the first column,
cluster size in the second and the cluster name in the last column. Interest
values of grouped data must reflect the total value of each cluster.
}
\examples{
d<-cbind(rnorm(500, 50, 20), rep(c(1:50),10)) #Non-grouped data
sample<-cluster.sample(d, n=10) #Non-grouped sample
sampleg<-aggregate(sample[,1], by=list(Category=sample[,2]), FUN=sum)
sampleg<-cbind(sampleg[,2], rep(10,10), sampleg[,1]) #Same sample but with grouped data
sum(d[,1])
cluster.estimator(N=50, data=sample, estimator="total", alpha=0.05)
cluster.estimator(N=50, data=sampleg, estimator="total", alpha=0.05)
}
