% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output_Tables.R
\name{biv_per_variable}
\alias{biv_per_variable}
\title{Returns a table based on the information of a \code{biv_compare_object} that
indicates the proportion of biased variables. It can be outputted as HTML or
LaTex Table, for example with the help of the \link[stargazer]{stargazer}
function.}
\usage{
biv_per_variable(
  biv_compare_object,
  ndigits = 1,
  varlabels = NULL,
  label_df = NULL
)
}
\arguments{
\item{biv_compare_object}{A object returned by the
\code{\link[sampcompR]{biv_compare}} function.}

\item{ndigits}{Number of digits that is shown in the table.}

\item{varlabels}{A character vector containing labels for the variables.}

\item{label_df}{A character vector containing labels for the data frames.}
}
\value{
A matrix, that indicates the proportion of bias for every individual
variable. This is given separately for every comparison, as well as averaged
over comparisons.
}
\description{
Returns a table based on the information of a \code{biv_compare_object} that
indicates the proportion of biased variables. It can be outputted as HTML or
LaTex Table, for example with the help of the \link[stargazer]{stargazer}
function.
}
\examples{

\dontrun{
data("card")

north <- card[card$south==0,]
white <- card[card$black==0,]

## use the function to plot the data 
bivar_data<-sampcompR::biv_compare(dfs = c("north","white"),
                                   benchmarks = c("card","card"),
                                   variables= c("age","educ","fatheduc","motheduc","wage","IQ"),
                                   data=TRUE)

table<-sampcompR::biv_per_variable(bivar_data)
noquote(table)}

}
