% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saeeb.R
\docType{package}
\name{saeeb}
\alias{saeeb}
\title{Small Area Estimation for Count Data}
\description{
This package provides functions for small area estimation using Empirical Bayes (EB) Poisson-Gamma model. This model only accomodates count data type and gives option whether to use covariates in the estimation or not. Each function returns EB estimators and mean squared error (MSE) estimators for each area. The EB estimators are obtained using the model proposed by Wakefield (2006) and refined by Kismiantini (2007) and the MSE estimators are obtained using Jackknife method by Jiang et. al. (2002).
}
\section{Functions}{

\describe{
 \item{\code{\link{ebcov}}}{Gives the EB Poisson-Gamma with covariates and the Jackknife MSE estimators.}
 \item{\code{\link{ebnocov}}}{Gives the EB Poisson-Gamma without covariates and the Jackknife MSE estimators.}
}
}

\references{
Clayton, David & Kaldor, John. (1987). \emph{Empirical Bayes Estimates of Age-Standardized Relative Risks for Use in Disease Mapping}. Biometrics, 43, 671-681.

Kismiantini. (2007). Pendugaan Statistik Area Kecil Berbasis Model Poisson-Gamma [Tesis]. Bogor: Institut Pertanian Bogor.

Rao, J. N. K. & Molina, Isabel. (2015). \emph{Small Area Estimation} (2nd ed.). New Jersey: John Wiley & Sons, Inc.

Wakefield, Jon. (2006). \emph{Disease Mapping and Spatial Regression with Count Data}. Biostatistics, 8, 2, 158–183. doi:10.1093/biostatistics/kxl008.
}
\author{
Rizki Ananda Fauziah, Ika Yuni Wulansari
}
