% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newtonRaphsonR.R
\name{newtonRaphsonR}
\alias{newtonRaphsonR}
\title{Estimates alpha and beta parameter with Newton Raphson method by J.N.K. Rao}
\usage{
newtonRaphsonR(data.dir, pcap, maxiter, tol)
}
\arguments{
\item{data.dir}{Direct estimates of the data from function pcapdir}

\item{pcap}{weighted sample mean and variance from function pcapdir}

\item{maxiter}{the Maximum iteration value}

\item{tol}{Tolerance error value in iteration}
}
\value{
This function returns a data frame with following objects :
\item{alpha_cap}{an alpha estimator by Newton Raphson method of J.N.K.Rao}
\item{beta_cap}{an beta estimator by Newton Raphson method of J.N.K.Rao}
}
\description{
Estimates alpha and beta parameter with Newton Raphson method by J.N.K. Rao
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])
newtonRaphsonR(data.dir = temp$direst, pcap = temp$pcap,
 maxiter = 100, tol = 0.00001)

##load dataset with weight value
data(dataEB)
temp = pcapdir(dataEB)
newtonRaphsonR(data.dir = temp$direst, pcap = temp$pcap,
 maxiter = 100, tol = 0.00001)

}
