% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{gen.data}
\alias{gen.data}
\title{Simulate data}
\usage{
gen.data(n, rho = 0.5, theta = 1, binary = FALSE)
}
\arguments{
\item{n}{Sample size.}

\item{rho}{Pairwise correlation between covariates.}

\item{theta}{Standard deviation of the random error.}

\item{binary}{If TRUE, generate binary responses; otherwise, by default,
create continuous responses.}
}
\value{
gen.data returns a list containning at least the following
components:
"X", a covariate matrix of n observations and p predictors;
"y", a univariate response;
"b.true", the actual coefficients for each predictor group.
}
\description{
Simulate data
}
\details{
This function simulates data as presented in Liu (2015).
}
\examples{
data <- gen.data(n=100)
names(data)
}
\references{
Liu, Y. (2015). Approaches to reduce and integrate data in
structured and high-dimensional regression problems in Genomics. Ph.D.
Dissertation, The Pennsylvania State University, University Park,
Department of Statistics.
}

