% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastClustering.R
\name{fastClustering}
\alias{fastClustering}
\title{Fast Spectral Clustering}
\usage{
fastClustering(
  dataFrame,
  smplPoint,
  stopCriteria = 0.99,
  neighbours = 7,
  similarity = TRUE,
  clustFunction,
  ...
)
}
\arguments{
\item{dataFrame}{The dataFrame.}

\item{smplPoint}{maximum of sample number for reduction.}

\item{stopCriteria}{criterion for minimizing intra-group distance and select final smplPoint.}

\item{neighbours}{number of points that will be selected for the similarity computation.}

\item{similarity}{if True, will use the similarity matrix for the clustering function.}

\item{clustFunction}{the clustering function to apply on data.}

\item{...}{additional arguments for the clustering function.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{results: }{clustering results}
 \item{sample: }{dataframe containing the sample used}
 \item{quantLabels: }{quantization labels}
 \item{clustLabels: }{results labels}
 \item{kmeans: }{kmeans quantization results}
}
}
\description{
This function will sample the data before performing a classification function on the samples and then applying K nearest neighbours.
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
res <- fastClustering(scale(sameTwoDisks),smplPoint = 500, 
                      stopCriteria = 0.99, neighbours = 7, similarity = TRUE,
                      clustFunction = UnormalizedSC, K = 2)
plot(sameTwoDisks, col = as.factor(res$clustLabels))

### Example 2: Speed and Stopping Distances of Cars
res <- fastClustering(scale(iris[,-5]),smplPoint = 500, 
                      stopCriteria = 0.99, neighbours = 7, similarity = TRUE,
                      clustFunction = spectralPAM, K = 3)
plot(iris, col = as.factor(res$clustLabels))
table(res$clustLabels,iris$Species)
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
