% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve}
\alias{resolve}
\title{Resolve an R version specification}
\usage{
resolve(version = "release", platform = current_r_platform())
}
\arguments{
\item{version}{Symbolic version name to resolve. Possible values are
\itemize{
\item \code{release}: the latest release version,
\item \code{devel}: Development version of R.
\item \code{next}: The next version of R. This is R-patched if there is no
ongoing release process currently. Otherwise it may be R-alpha,
R-beta, or R-rc or R-prerelease.
\item \code{oldrel}: The previous version of R, not counting patch versions.
\item \verb{oldrel/<n>}: The n-th previous version of R, not counting patch
versions.
\item \code{x.y.z}: A specific R version, e.g. 4.5.1.
\item \code{x.y}: The last patch release from a minor R branch, e.g. 4.4.
}}

\item{platform}{Operating system version. Defaults to
\code{\link[=current_r_platform]{current_r_platform()}}. Possible values are:
\itemize{
\item \code{NA}: to get information about platform-independent release archives.
\item \code{windows}: x86_64 Windows.
\item \code{windows-x86_64}: the same.
\item \code{windows-aarch64}: aarch64 Windows.
\item \code{macos}: arm64 macOS.
\item \code{macos-arm64}: the same.
\item \code{macos-x86_64}: x86_64 macOS.
\item \verb{linux-<distro>-<release>}: x86_64 Linux on the given distribution
and release, e.g. \code{linux-ubuntu-22.04}.
\item A target triplet of the form \code{cpu-vendor-os-abi}. On Linux it should
also include the distribution name and release. See
\code{\link[=current_r_platform]{current_r_platform()}} for examples.
}}
}
\value{
A one row data frame, with columns \code{version}, \code{date},
\code{nickname}, \code{semver}, \code{url}, \code{type}, \code{rtools_url} (only for Windows).
}
\description{
Resolve an R version specification
}
\details{
\code{resolve()} caches its results in the current R session. To clear the
cache restart R or set the \code{R_VERSION_CACHE_TIMEOUT} environment
variable to \code{0}.
}
\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
resolve("release", "windows")
resolve("4.4", "windows-aarch64")
resolve("oldrel", "macos")
resolve("devel", "linux-gnu-ubuntu-24.04")
resolve("devel", "aarch64-unknown-linux-gnu-ubuntu-22.04")
\dontshow{\}) # examplesIf}
}
