% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanTech.R
\name{meanTech}
\alias{meanTech}
\title{Computing the mean of technical replicates}
\usage{
meanTech(x, groups, numOfFactors, block)
}
\arguments{
\item{x}{A raw data frame containing technical replicates.}

\item{groups}{An integer vector or character vector specifying the column(s) to group
by before calculating the mean of technical replicates.}

\item{numOfFactors}{Integer. Number of experimental factor columns}

\item{block}{Character. Block column name or \code{NULL}.}
}
\value{
A data frame with the mean of technical replicates for each group.
}
\description{
Computes the arithmetic mean of technical replicates for each sample or group.
This is often performed before ANOVA or other statistical analyses to simplify
comparisons between experimental groups.
}
\details{
The \code{meanTech} function calculates the mean of technical replicates
based on one or more grouping columns. This reduces the dataset to a single
representative value per group, facilitating downstream analysis such as
fold change calculation or ANOVA.
}
\examples{

# Example input data frame with technical replicates
data1 <- read.csv(system.file("extdata", "data_withTechRep.csv", package = "rtpcr"))

# Calculate mean of technical replicates using first four columns as groups
meanTech(data1,
         groups = 1:2,
         numOfFactors = 1,
         block = NULL)

# Another example using different dataset and grouping columns
data2 <- read.csv(system.file("extdata", "data_Lee_etal2020qPCR.csv", package = "rtpcr"))
meanTech(data2, groups = 1:3,
         numOfFactors = 2,
         block = NULL)
}
\author{
Ghader Mirzaghaderi
}
