% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_toot}
\alias{post_toot}
\title{Post status update to user's Mastodon account}
\usage{
post_toot(
  status = "my first rtoot #rstats",
  media = NULL,
  alt_text = NULL,
  token = NULL,
  in_reply_to_id = NULL,
  sensitive = FALSE,
  spoiler_text = NULL,
  visibility = "public",
  scheduled_at = NULL,
  language = NULL,
  verbose = TRUE
)
}
\arguments{
\item{status}{character, toot status. Must be 500 characters or less.}

\item{media}{character, path to media to add to post}

\item{alt_text}{character, a plain-text description of the media, for accessibility purposes.}

\item{token}{user bearer token (read from file by default)}

\item{in_reply_to_id}{character, ID of the status being replied to, if status is a reply}

\item{sensitive}{logical, mark status and attached media as sensitive?}

\item{spoiler_text}{character, text to be shown as a warning or subject before the actual content. Statuses are generally collapsed behind this field.}

\item{visibility}{character, Visibility of the posted status. One of public (default), unlisted, private, direct.}

\item{scheduled_at}{ISO 8601 Datetime at which to schedule a status. Must be at least 5 minutes in the future.}

\item{language}{ISO 639 language code for this status.}

\item{verbose}{logical whether to display messages}
}
\value{
no return value, called for site effects
}
\description{
Be aware that excessive automated posting is frowned upon (or even against the ToS) in many instances. Make sure to check the ToS of your instance and be mindful when using this function.
}
\examples{
\dontrun{
# post a simple status
post_toot("my first rtoot #rstats")
# post a media file with alt text
post_toot("look at this pic", media = "path/to/image", alt_text = "describe image")
}
}
