% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getBrukerMCFSpots}
\alias{getBrukerMCFSpots}
\alias{getBrukerMCFIndices}
\title{Get spot names and indices from a Bruker MCF file}
\usage{
getBrukerMCFSpots(reader)

getBrukerMCFIndices(reader)
}
\arguments{
\item{reader}{An openRTMS reader object of class \code{rtmsBrukerMCFReader}}
}
\value{
A data.frame with an \code{Index} column containing the indices of each
acquisition (used by other functions such as \code{getSpectrum} or \code{getSample}),
a \code{SpotNumber} column containing the "Spot Number" metadata value for each
acquisition, and a \code{Timestampe} column containing the time at which each
acquisition was collected by the instrument.
}
\description{
Assembles a table of all acquisitions in a Bruker MCF file; Bruker
measurements are often identified by the metadata parameter "Spot Number",
so this function extracts that specific metadata value and joins it with the
indices used to pick out spectra in other functions.  Also retrieves the
timestamp at which acquisition was taken, if acquisitions must be identified
by order.
}
\section{Functions}{
\itemize{
\item \code{getBrukerMCFIndices()}: Retrieves a vector of all the indices
(beginning with zero) of the acquisitions in the MCF file.  Faster than
\code{getBrukerMCFSpots} but contains no metadata or spot names

}}
