% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{a2a}
\alias{a2a}
\alias{set_a_equal}
\title{Set process thresholds equal}
\usage{
a2a(model, names, keep_consts = FALSE)

set_a_equal(model, names, keep_consts = FALSE)
}
\arguments{
\item{model}{A list of the class \code{drtmpt_model}.}

\item{names}{Character vector giving the names of the processes for which the process thresholds should be equal. If
\code{length(names) = 1} then the corresponding process threshold will be estimated (i.e., it will be set to NA)}

\item{keep_consts}{Can be one of the following
\itemize{
 \item logical value: \code{FALSE} (default) means none of the constants for \code{names} in the \code{model} will be kept; The thresholds of
   the reference process (i.e., first of \code{names} in alphabetical order) will be set to \code{NA} (i.e., will be estimated) and the others
   will be set to the name of the reference process (i.e., will be set to equal the reference process thresholds). \code{TRUE} means
   the constant of the reference process threshold (if specified) is used for all other processes.
 \item numeric value: index for \code{names}. If 1, the constant of the first process in \code{names} (in original order defined by the user) is
   used for all other thresholds of the processes in \code{names}. If 2, the constant of the second process is used. And so on.
}}
}
\value{
A list of the class \code{drtmpt_model}.
}
\description{
Setting multiple process thresholds (a) equal. One of the process thresholds will be estimated and the other
  named thresholds will be set to equal the former. The equality can be removed by only using one name of a process.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process thresholds for both detection processes ("do" and "dn")
# will be set equal.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_drtmpt_model(mdl_file = mdl_2HTM)

## make do = dn
new_model <- a2a(model = model, names = c("do", "dn"))
new_model


## make do = dn
new_model <- set_a_equal(model = model, names = c("do", "dn"))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{a2const}}, \code{\link{nu2const}}, \code{\link{nu2nu}}, \code{\link{omega2const}}, and \code{\link{omega2omega}}
}
\author{
Raphael Hartmann
}
