% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_traffic_light}
\alias{set_formatter_traffic_light}
\title{Set traffic light formatter}
\usage{
set_formatter_traffic_light(
  widget,
  column,
  min = NA,
  max = NA,
  color = c("green", "orange", "red"),
  hoz_align = "center"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{min}{(numeric): The minimum value for progress bar.
If set to \code{NA}, the minimum value of the column is used.}

\item{max}{(numeric): The maximum value for progress bar.
If set to \code{NA}, the maximum value of the column is used.}

\item{color}{(character): Either a single color or a vector of colors}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set traffic light formatter
}
\examples{
data <- data.frame(
  label = 1:10,
  value = 1:10
)

tabulator(data, width = 200) |>
  set_formatter_traffic_light("value") |>
  set_formatter_plaintext("label", hoz_align = "center")
}
