% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_parse_response.R
\name{rt_parse_response}
\alias{rt_parse_response}
\title{Parse an RT response in its parts as a list}
\usage{
rt_parse_response(response, verbose = FALSE)
}
\arguments{
\item{response}{(character) Parsed response from \code{\link[httr]{content}}}

\item{verbose}{(logical) Optional, defaults to \code{TRUE}.
Prints more information during parsing.}
}
\value{
(list) List with named elements status, message, and body
}
\description{
The RT API uses overrides default HTTP behavior with their own set of status
codes, messages, and response formats. This function parses that custom
implementation and presents it into something that's easier to build a
package with.
}
\details{
For example, a response like:\preformatted{"RT/4.4.3 200 Ok

# Ticket 2 created.
}

is turned into the list:\preformatted{$status
[1] 200

$message
[1] "Ok"

$body
[1] "# Ticket 2 created."
}
}
