% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartId.R
\name{chartId}
\alias{chartId}
\alias{chartId,character-method}
\alias{chartId,Chart-method}
\title{Retrieves chartId of SyncroSim Chart}
\usage{
chartId(ssimObject)

\S4method{chartId}{character}(ssimObject)

\S4method{chartId}{Chart}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{Chart-class}} object}
}
\value{
An integer: chart id.
}
\description{
Retrieves the Chart Id of a SyncroSim \code{\link{Chart-class}}.
}
\examples{
\dontrun{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set the SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, 
                         session = mySession, 
                         packages = "stsim",
                         overwrite = TRUE) 
myProject <- project(myLibrary, project = "Definitions")

# Get the chart object corresponding to the chart called "My Chart"
myChart <- chart(myProject, chart = "My Chart")

# Get Chart ID for SyncroSim Chart
chartId(myChart)
}

}
