% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPackage.R
\name{addPackage}
\alias{addPackage}
\alias{addPackage,character-method}
\alias{addPackage,SsimLibrary-method}
\title{Add SyncroSim package(s)}
\usage{
addPackage(ssimLibrary, packages, versions = NULL, forceUpdate = FALSE)

\S4method{addPackage}{character}(ssimLibrary, packages, versions = NULL, forceUpdate = FALSE)

\S4method{addPackage}{SsimLibrary}(ssimLibrary, packages, versions = NULL, forceUpdate = FALSE)
}
\arguments{
\item{ssimLibrary}{\code{\link{SsimLibrary-class}} object}

\item{packages}{character string or vector of package name(s)}

\item{versions}{character string or vector of package version(s). If
\code{NULL} then uses the latest installed version of the package}

\item{forceUpdate}{logical. If \code{FALSE} (default) user will be prompted
to approve any required updates. If \code{TRUE}, required updates will
be applied silently.}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful addition
of the package) or \code{FALSE} upon failure.
}
\description{
Adds package(s) to a \code{\link{SsimLibrary-class}}.
}
\examples{
\dontrun{
# Install "stsim" and "stsimecodep" SyncroSim packages
installPackage(packages = c("stsim", "stsim"),
               versions = c("4.0.1", "4.3.5"))
installPackage("stsimecodep")

# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Add package
addPackage(myLibrary, packages = "stsim", versions = "4.0.1")
addPackage(myLibrary, packages = "stsimecodep")
packages(myLibrary)

# Change package version
addPackage(myLibrary, packages = "stsim", versions = "4.3.5")

# Remove package
removePackage(myLibrary, packages = c("stsim", "stsimecodep"))
packages(myLibrary)
}

}
\seealso{
\code{\link{packages}}
}
