# Standalone file: do not edit by hand
# Generated by: pkgtools from @unit tags
# ----------------------------------------------------------------------
library(rsurvstat)

# unit test start: .df_to_list_of_lists ----

test_that(".df_to_list_of_lists unit test", {

  # Automatically generated test case from roxygen @unit tag
  # Do not edit here - follow the link to the source file.
  # or navigate to topic with <F2>
  F2 = .df_to_list_of_lists
  

  iris_list <- .df_to_list_of_lists(datasets::iris)
  # TODO: iris_list has lost Petal.Length as it is interpreting Petal.Width as
  # nested item and it overwrites Petal.Length rather than merging with it.
  
  testthat::expect_equal(
    iris_list[[1]]$Species,
    iris$Species[[1]]
  )
  
  mtcars_nest <- datasets::mtcars %>%
    dplyr::mutate(name = rownames(.)) %>%
    tidyr::nest(details = -c(cyl, gear))
  
  mtcars_list <- mtcars_nest %>% .df_to_list_of_lists()
  
  mtcars_unnest <- mtcars_list %>% .list_of_lists_to_df()
  
  testthat::expect_equal(
    mtcars_list[[1]]$details[[1]]$name,
    mtcars_nest$details[[1]]$name[[1]]
  )

  # generates a failure if the overall test is failing with a link to the 
  # source of the unit test:
  testthat::expect(rlang::caller_env(n = 2)$ok,
    failure_message = "Source link for failing @unit test.",
    srcref = srcref(srcfile("../../R/import-standalone-df-list-df.R"), c(29, 1, 29+1, 1))
  )
})

# unit test end: .df_to_list_of_lists ----
# unit test start: .list_of_lists_to_df ----

test_that(".list_of_lists_to_df unit test", {

  # Automatically generated test case from roxygen @unit tag
  # Do not edit here - follow the link to the source file.
  # or navigate to topic with <F2>
  F2 = .list_of_lists_to_df
  

  iris_list <- .df_to_list_of_lists(iris, .fix = FALSE)
  iris2 <- .list_of_lists_to_df(iris_list, .fix = FALSE)
  
  testthat::expect_equal(datasets::iris, as.data.frame(iris2))
  
  mtcars_nest <- datasets::mtcars %>%
    dplyr::mutate(name = rownames(.)) %>%
    tidyr::nest(details = -c(cyl, gear))
  
  mtcars_list <- mtcars_nest %>% .df_to_list_of_lists()
  
  mtcars_nest2 <- mtcars_list %>% .list_of_lists_to_df()
  
  testthat::expect_equal(
    mtcars_nest2$details[[2]],
    mtcars_nest$details[[2]]
  )
  
  # test unequal length vector column is mapped to list of vectors
  # and multiply named nests are treated as rows
  testlist <- list(
    row = list(a = 1:5, b = "x"),
    row = list(a = 2:4, b = "y"),
    row = list(a = 3, b = "z")
  )
  testdf <- testlist %>% .list_of_lists_to_df()
  testthat::expect_equal(testdf$b, c("x", "y", "z"))
  testthat::expect_equal(testdf$a[[2]], 2:4)

  # generates a failure if the overall test is failing with a link to the 
  # source of the unit test:
  testthat::expect(rlang::caller_env(n = 2)$ok,
    failure_message = "Source link for failing @unit test.",
    srcref = srcref(srcfile("../../R/import-standalone-df-list-df.R"), c(66, 1, 66+1, 1))
  )
})

# unit test end: .list_of_lists_to_df ----
# unit test start: .transpose ----

test_that(".transpose unit test", {

  # Automatically generated test case from roxygen @unit tag
  # Do not edit here - follow the link to the source file.
  # or navigate to topic with <F2>
  F2 = .transpose
  

  # create a test nested data frame:
  
  mtcars_nest <- datasets::mtcars %>%
    dplyr::mutate(name = rownames(.)) %>%
    tidyr::nest(by_carb = -c(cyl, gear, carb)) %>%
    tidyr::nest(by_cyl_and_gear = -c(cyl, gear))
  
  mtcars_list <- mtcars_nest %>% .transpose()
  
  mtcars_nest2 <- mtcars_list %>% .transpose()
  
  testthat::expect_equal(mtcars_nest, mtcars_nest2)

  # generates a failure if the overall test is failing with a link to the 
  # source of the unit test:
  testthat::expect(rlang::caller_env(n = 2)$ok,
    failure_message = "Source link for failing @unit test.",
    srcref = srcref(srcfile("../../R/import-standalone-df-list-df.R"), c(116, 1, 116+1, 1))
  )
})

# unit test end: .transpose ----
# end of unit tests ----
