% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{findOAuthIntegration}
\alias{findOAuthIntegration}
\title{Find OAuth Integration by Criteria}
\usage{
findOAuthIntegration(
  name = NULL,
  display_name = NULL,
  guid = NULL,
  authenticated = NULL
)
}
\arguments{
\item{name}{Optional integration name to match. Supports regular expressions.
For exact matches, use anchors like \code{^github-main$}.}

\item{display_name}{Optional display name to match. Supports regular expressions.
For exact matches, use anchors like \code{^GitHub Production$}.}

\item{guid}{Optional globally unique identifier (GUID) to match. Exact match only.}

\item{authenticated}{Optional logical indicating whether to match only authenticated integrations (TRUE),
only unauthenticated integrations (FALSE), or either (NULL, the default). Exact match only.}
}
\value{
A list containing the integration metadata, or \code{NULL} if no matching integration is found.
}
\description{
Search for an OAuth integration that matches the specified criteria. Returns the first
integration that matches all provided filter parameters. If no parameters are provided,
returns the first available integration.
}
\note{
This function requires Posit Workbench version 2026.01.0 or later. It works
in any IDE running within a Posit Workbench session (not just RStudio).
}
\examples{
\dontrun{
# Find by exact name
integration <- findOAuthIntegration(name = "^my-github-integration$")

# Find by name pattern (any integration with "github" in the name)
integration <- findOAuthIntegration(name = "github")

# Find authenticated integration by display name pattern
integration <- findOAuthIntegration(display_name = "GitHub.*", authenticated = TRUE)

# Find by exact GUID
integration <- findOAuthIntegration(guid = "4c1cfecb-1927-4f19-bc2f-d8ac261364e0")
}
}
