% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_igraph.R
\name{as_igraph}
\alias{as_igraph}
\title{as.igraph}
\usage{
as_igraph(x, tol = 100 * .Machine$double.eps, tol1 = 8 * tol, ...)
}
\arguments{
\item{x}{a similarity object}

\item{tol}{numeric scalar >= 0.  Smaller differences are not
    considered, see \code{\link[base]{all.equal.numeric}}.}

\item{tol1}{numeric scalar >= 0.  \code{isSymmetric.matrix()}
    \sQuote{pre-tests} the first and last few rows for fast detection of
    \sQuote{obviously} asymmetric cases with this tolerance.  Setting it
    to length zero will skip the pre-tests.}

\item{...}{further parameters used by \link[igraph:graph_from_adjacency_matrix]{igraph::graph_from_adjacency_matrix}}
}
\value{
an igraph object
}
\description{
Converts a data frame of similarity coefficients into a graph.
}
\examples{
files <- list.files(path=system.file("examples", package="rscc"), pattern="*.R$", full.names = TRUE)
prgs  <- sourcecode(files, title=basename(files))
docs  <- documents(prgs)
simm  <- similarities(docs)
# a similarity coefficients equal to zero does not create an edge!
g <- as_igraph(simm, diag=FALSE)
# thicker edges have higher similarity coefficients
plot(g, edge.width=1+3*igraph::E(g)$weight)
}
