% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssessmentItem.R
\docType{class}
\name{AssessmentItem-class}
\alias{AssessmentItem-class}
\alias{AssessmentItem}
\title{Class AssessmentItem}
\description{
Abstract class \code{AssessmentItem} is responsible for creating a root element
'assessmentItem' in XML task description according to QTI 2.1. This class is
not meant to be instantiated directly; instead, it serves as a base for
derived classes.
}
\section{Slots}{

\describe{
\item{\code{identifier}}{A character representing the unique identifier of the
assessment task. By default, it is generated as 'id_task_dddd', where dddd
represents random digits.}

\item{\code{title}}{A character representing the title of the XML file associated
with the task. By default, it takes the value of the identifier.}

\item{\code{content}}{A list of character content to form the text of the question,
which can include HTML tags. For tasks of the \link{Entry} type, it must also
contain at least one instance of Gap objects, such as \linkS4class{TextGap},
\link{TextGapOpal}, \link{NumericGap}, or \link{InlineChoice}.}

\item{\code{prompt}}{An optional character representing a simple question text,
consisting of one paragraph. This can supplement or replace content in the
task. Default is "".}

\item{\code{points}}{A numeric value, optional, representing the number of points for
the entire task. Default is 1, but pay attention:
\itemize{
\item For tasks of the \link{Entry} type, it is
calculated as the sum of the gap points by default.
\item For tasks of the \link{DirectedPair}, the default is calculated as 0.5 points
per pair.
\item For tasks of the \link{MatchTable} type, it can also be calculated as the sum
of points for individual answers, when provided.
\item For tasks of the \link{MultipleChoice} type, points is numeric vector and
required. Each number in this vector determines the number of points that
will be awarded to a candidate if they select the corresponding answer. The
order of the scores must match the order of the \code{choices}. It is possible
to assign negative values to incorrect answers. All answers with a
positive score are considered correct.
}}

\item{\code{feedback}}{A list containing feedback messages for candidates. Each
element of the list should be an instance of either \link{ModalFeedback},
\link{CorrectFeedback}, or \link{WrongFeedback} class.}

\item{\code{calculator}}{A character, optional, determining whether to show a
calculator to the candidate. Possible values:
\itemize{
\item "simple"
\item "scientific"
}}

\item{\code{files}}{A character vector, optional, containing paths to files that will
be accessible to the candidate during the test/exam.}

\item{\code{metadata}}{An object of class \link{QtiMetadata} that holds metadata information
about the task.}
}}

