% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rprintv.R
\name{rprintv}
\alias{rprintv}
\title{Build a character vector or list with variable-based
string formatting}
\usage{
rprintv(x, ...)
}
\arguments{
\item{x}{The character vector or list to be transformed}

\item{...}{The arguments that specify the set of values to be
placed}
}
\description{
The \code{rprintv} function applies variable-based formatter to
transform the given character vector to specific texts with
named variables replaced by a given set of values in correct
formats.
}
\examples{
\dontrun{

# Format a single-entry character vector with variable mechanism
rprintf('Hello, $name', name='world')
rprintf('$name ($age years old)',name='Ken',age=24)
rprintf('He is $age but has a height of $height:.2fcm',age=18,height=190)
rprintf('$a, $b:.1f, $c:+.2f, $b, $a:.0f',a=1.56,b=2.34,c=3.78)
}
}

