% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_sliding_windows_df}
\alias{create_sliding_windows_df}
\title{Sliding windows}
\usage{
create_sliding_windows_df(vector, window_size)
}
\arguments{
\item{vector}{A numeric or integer vector that is the time series to be used to create sliding windows}

\item{window_size}{An integer specifying the size (i.e., number of elements) of the windowed time series desired}
}
\value{
A \code{data.frame} where each row is a subset (a sliding window) of a time series.
}
\description{
This unexported helper function is used within \code{plane_shape()} to generate sliding windows from a vector and return a data frame where each row is a subset (a sliding window) of a time series. The length of the each windowed time series (and therefore number of columns) is equal to "window_size". The number of windows is equal to \code{(length(vector) - window_size) + 1}. For example, given a time series of length 38 and a window size of length 4, then there will be 35 windowed time series (rows), with 4 time stamps each (columns).
}
