% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journeys.r
\name{getTraj}
\alias{getTraj}
\title{Find a plausible developmental journey}
\usage{
getTraj(rdmap, tm, sourceCellInds, terminalCellsInd = NULL, momAdj = 0.5,
  w1 = exp(1), w2 = 1, simLen = 50, sim.seed = NULL, varEst = 10)
}
\arguments{
\item{rdmap}{reduced dimensionality matrix with cells in rows and dims in columns}

\item{tm}{Transition matrix}

\item{sourceCellInds}{Starting sell indices}

\item{terminalCellsInd}{Terminal cell indices}

\item{momAdj}{Weighting to adjust momentum. From 0-1. Lower numbers make smaller
adjustment to momentum vector.}

\item{w1}{Parameter - Base used for modifying of tm probs.}

\item{w2}{Parameter - Multiplifaction factor used for modifying tm probs.}

\item{simLen}{Maximum number of allowable tranisitons}

\item{sim.seed}{Random seed for reproducibility}

\item{varEst}{Number of alternatives to sample for estimating variance.}
}
\value{
Returns a data.frame of ordered indices and momentums
}
\description{
Return a plausible developmental journey
}
\details{
Return a plausible developmental journey
}
\examples{
\dontrun{
traj <- getTraj(rdmap, tm, startCells, terminalCells)
}
}
\author{
Wajid Jawaid
}
