% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-bag.R
\name{bag_rocrate}
\alias{bag_rocrate}
\alias{bag_rocrate.character}
\alias{bag_rocrate.rocrate}
\title{Bag the contents of an RO-Crate}
\usage{
bag_rocrate(x, ...)

\method{bag_rocrate}{character}(x, ..., output = x, force_bag = FALSE)

\method{bag_rocrate}{rocrate}(x, ..., path, output = path, overwrite = FALSE, force_bag = FALSE)
}
\arguments{
\item{x}{A string to a path containing at the very minimum an RO-Crate
metadata descriptor file, \code{ro-crate-metadata.json}. Alternatively, an
object with the \link[rocrateR]{rocrate} class.}

\item{...}{Additional parameters, see below.}

\item{output}{String with path where the RO-Crate bag will be stored
(default: \code{x} - same path as the input value).}

\item{force_bag}{Boolean flag to indicate whether the force the creation of
a 'bag' even if not all the files were successfully bagged
(default: \code{FALSE} ~ check if all the files were copied successfully).}

\item{path}{String with path to the root of the RO-Crate.}

\item{overwrite}{Boolean flag to indicate if the RO-Crate metadata descriptor
file should be overwritten if already inside \code{path} (default: \code{FALSE}).}
}
\value{
String with full path to the final RO-Crate bag.
}
\description{
Bag the contents of an RO-Crate using the BagIt file packaging format v1.0.
For more details see the definition:
\doi{10.17487/RFC8493}
}
\seealso{
Other bag_rocrate: 
\code{\link{is_rocrate_bag}()},
\code{\link{unbag_rocrate}()}
}
\concept{bag_rocrate}
