% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepend_ids_to_source.R,
%   R/prepend_ids_to_sources.R
\name{prepend_ids_to_source}
\alias{prepend_ids_to_source}
\alias{prepending_uids}
\alias{prepend_ids_to_sources}
\title{Prepending unique utterance identifiers}
\usage{
prepend_ids_to_source(
  input,
  output = NULL,
  origin = Sys.time(),
  follow = NULL,
  followBy = NULL,
  rlWarn = rock::opts$get(rlWarn),
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

prepend_ids_to_sources(
  input,
  output = NULL,
  outputPrefix = "",
  outputSuffix = "_withUIDs",
  origin = Sys.time(),
  follow = NULL,
  followBy = NULL,
  uidSpacing = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{input}{The filename or contents of the source
for \code{prepend_ids_to_source}; and the directory containing the
sources, or a list of character vectors, for \code{prepend_ids_to_sources}.}

\item{output}{The filename where to write the resulting file for
\code{prepend_ids_to_source} and the directory where to write the
resulting files for \code{prepend_ids_to_sources}}

\item{origin}{The time to use for the first identifier.}

\item{follow}{A vector of one or more UIDs (or a list; lists are
recursively \code{unlist()}ed); the highest UID will be taken, converted
to a timestamp, and used as \code{origin} (well, 0.01 second later), so that the
new SQUIDs will follow that sequence (see \code{\link[squids:squids]{squids::squids()}}).}

\item{followBy}{When following a vector of UIDs, this can be used to
specify the distance between the two vectors (see \code{\link[squids:squids]{squids::squids()}}).}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{preventOverwriting}{Whether to overwrite existing files (\code{FALSE})
or prevent that from happening (\code{TRUE}).}

\item{encoding}{The encoding of the file(s).}

\item{silent}{Whether to be chatty or quiet.}

\item{outputPrefix, outputSuffix}{The prefix and suffix to add to the
filenames when writing the processed files to disk.}

\item{uidSpacing}{The number of UID spaces to leave between sources (in case
more data may follow in with source).}
}
\value{
The source with prepended uids, either invisible (if \code{output}
if specified) or visibly (if not).
}
\description{
This function prepends unique utterance identifiers to each
utterance (line) in a source. Note that you'll probably want
to clean the sources using \code{\link[=clean_sources]{clean_sources()}} first.
}
\examples{
### Simple example
rock::prepend_ids_to_source(
  "brief\nexample\nsource"
);

### Example including fake YAML fragments
longerExampleText <-
  c(
    "---",
    "First YAML fragment",
    "---",
    "So this is an utterance (i.e. outside of YAML)",
    "This, too.",
    "---",
    "Second fragment",
    "---",
    "Another real utterance outside of YAML",
    "Another one outside",
    "Last 'real utterance'"
  );

rock::prepend_ids_to_source(
  longerExampleText
);

}
