% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinFDATest}
\alias{robinFDATest}
\title{robinFDATest}
\usage{
robinFDATest(x, verbose = FALSE)
}
\arguments{
\item{x}{A robin class object. The output of the functions:
\code{\link{robinRobust}} and \code{\link{robinCompare}}.}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
Two plots: the fitted curves and the adjusted p-values. A vector of the adjusted p-values.
}
\description{
The function implements the Interval Testing Procedure to 
test the difference between two curves.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
comp <- robinCompare(graph=graph, method1="fastGreedy",method2="infomap")
\donttest{robinFDATest(comp)}
}
