% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{methodCommunity}
\alias{methodCommunity}
\title{methodCommunity}
\usage{
methodCommunity(
  graph,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "leiden", "other"),
  leiden_objective_function = c("modularity", "CPM"),
  ...,
  FUN = NULL,
  verbose = FALSE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"optimal", "leiden","other".}

\item{leiden_objective_function}{objective_function parameter for leiden only
for method}

\item{...}{additional parameters to use with any of the previous described 
methods (see igraph package community detection methods for more details 
i.e. \link[igraph]{cluster_walktrap})}

\item{FUN}{in case the @method parameter is "other" there is the possibility 
to use a personal function passing its name through this parameter.
The personal parameter has to take as input the @graph and the @weights 
(that can be NULL), and has to return a community object.}

\item{verbose}{flag for verbose output (default as FALSE)}
}
\value{
A Communities object.
}
\description{
This function detects the community structure of a graph.
To detect the community structure the user can choose one of the methods implemented 
in igraph.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
methodCommunity (graph=graph, method="louvain") 
}
