% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{exp_cov_function}
\alias{exp_cov_function}
\title{Exponential covariance function over a grid}
\usage{
exp_cov_function(grid, alpha, beta)
}
\arguments{
\item{grid}{a vector of time points.}

\item{alpha}{the alpha parameter in the exponential covariance formula.}

\item{beta}{the beta parameter in the exponential covariance formula.}
}
\description{
This function computes the discretization of an exponential
covariance function of the form:
\deqn{C( s, t ) = \alpha e^{ - \beta | s - t | }}
over a 1D grid \eqn{[t_0, t_1, \ldots, t_{P-1}]}, thus obtaining the
\eqn{P \times P} matrix
of values:
\deqn{ C_{i,j} = C( t_i, t_j ) = \alpha e^{ - \beta | t_i - t_j | } .}
}
\examples{

grid = seq( 0, 1, length.out = 5e2 )

alpha = 0.2
beta = 0.3

dev.new()
image( exp_cov_function( grid, alpha, beta ),
       main = 'Exponential covariance function',
       xlab = 'grid', ylab = 'grid')


}
\seealso{
\code{\link{generate_gauss_fdata}},
\code{\link{generate_gauss_mfdata}}
}
