% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfanova.R
\name{pointwise_sample_mean_fun}
\alias{pointwise_sample_mean_fun}
\title{Pointwise sample mean functions}
\usage{
pointwise_sample_mean_fun(
  x,
  plot = TRUE,
  values = FALSE,
  type = "l",
  lty = 1,
  main = "Sample mean functions",
  ...
)
}
\arguments{
\item{x}{a list of length \eqn{\ell} with elements being \eqn{n\times p} matrices of data
corresponding to \eqn{n} functional observations measured in \eqn{p} design time points under given
experimental conditions.}

\item{plot}{a logical indicating of whether to draw the values of the pointwise sample mean functions.
The default is \code{TRUE}.}

\item{values}{a logical indicating of whether to return the values of the pointwise sample mean functions.
The default is \code{FALSE}.}

\item{type}{1-character string giving the type of plot desired, the same as in the \code{matplot()} function.
The default is \code{"l"} for lines.}

\item{lty}{vector of line types, the same as in the \code{matplot()} function. The default is 1 (solid lines).}

\item{main}{a main title for the plot, the same as in the \code{plot()} function. The default is \code{Sample mean functions}.}

\item{...}{other graphical parameters, the same as in the \code{matplot()} function.}
}
\value{
If \code{values = TRUE}, a matrix of values of the pointwise sample mean functions.
}
\description{
The function \code{pointwise_sample_mean_fun()} calculates and draws the pointwise sample mean functions.
}
\examples{
# preparation of the DTI data set, for details see Kurylo and Smaga (2023)
library(refund)
data(DTI)
# MS patients
DTI_ms <- DTI[DTI$case == 1, ]
miss_data <- c()
for (i in 1:340) if (any(is.na(DTI_ms$cca[i, ]))) miss_data <- c(miss_data, i)
DTI_ms <- DTI_ms[-miss_data, ]
DTI_ms_2 <- DTI_ms[DTI_ms$Nscans == 4, ]
xx <- vector("list", 4)
for (i in 1:4) {
  xx[[i]] <- DTI_ms_2$cca[DTI_ms_2$visit == i, ]
}
xx[[1]] <- xx[[1]][-14, ]
xx[[3]] <- xx[[3]][-14, ]
yy <- xx
for (i in seq_len(4)) yy[[i]] <- yy[[i]][1:17, ]
# sample mean functions
oldpar <- par(mfrow = c(1, 1), mar = c(4, 4, 2, 0.1))
pointwise_sample_mean_fun(yy, values = FALSE,
                          col = 1:4, xlab = "t", ylab = "FA", xaxt = "n")
axis(1, c(1, 15, 30, 45, 60, 75, 93), labels = c(1, 15, 30, 45, 60, 75, 93))
legend(x = 36, y = 0.64, legend = 1:4, lty = 1, col = 1:4, title = "Visit")
par(oldpar)

}
\references{
Kurylo K., Smaga L. (2023) Functional repeated measures analysis of variance and its application. Preprint https://arxiv.org/abs/2306.03883
}
