% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/providers.R
\name{mz_set_host}
\alias{mz_set_host}
\alias{mz_get_host}
\alias{mz_set_search_host_geocode.earth}
\alias{mz_set_search_host_nyc_geosearch}
\alias{mz_set_tile_host_nextzen}
\title{Set up a host provider for a PELIAS service}
\usage{
mz_set_host(which, provider)

mz_get_host(which)

mz_set_search_host_geocode.earth(key = Sys.getenv("GEOCODE.EARTH_KEY"))

mz_set_search_host_nyc_geosearch()

mz_set_tile_host_nextzen(key = Sys.getenv("NEXTZEN_KEY"))
}
\arguments{
\item{which}{One of "search", "matrix", or "tile"}

\item{provider}{A provider, created using \code{\link{mz_provider}}}

\item{key}{API key}
}
\description{
rmapzen works with most implementations of PELIAS. Use this function to set
up the basic information required to connect to a particular provider.
Provider-specific setup functions include information to set up known
providers.
}
\seealso{
\code{\link{mz_provider}}
}
