% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_lines.R
\name{ms_innerlines}
\alias{ms_innerlines}
\title{Create a line layer consisting of shared boundaries with no attribute data}
\usage{
ms_innerlines(input, ...)
}
\arguments{
\item{input}{input polygons object to convert to inner lines. One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{...}{
  Arguments passed on to \code{\link[=apply_mapshaper_commands]{apply_mapshaper_commands}}
  \describe{
    \item{\code{force_FC}}{should the output be forced to be a FeatureCollection (or sf
object or Spatial*DataFrame) even if there are no attributes? Default
\code{TRUE}. If FALSE and there are no attributes associated with the
geometries, a GeometryCollection (or Spatial object with no dataframe, or
sfc) will be output.}
    \item{\code{sys}}{Should the system mapshaper be used instead of the bundled
mapshaper? Gives better performance on large files. Requires the mapshaper
node package to be installed and on the PATH.}
    \item{\code{sys_mem}}{How much memory (in GB) should be allocated if using the
system mapshaper (\code{sys = TRUE})? Default 8. Ignored if \code{sys = FALSE}. This
can also be set globally with the option \code{"mapshaper.sys_mem"}}
    \item{\code{quiet}}{If \code{sys = TRUE}, should the mapshaper messages be silenced?
Default \code{FALSE}. This can also be set globally with the option
\code{"mapshaper.sys_quiet"}}
    \item{\code{gj2008}}{Generate output that is consistent with the pre-RFC 7946
GeoJSON spec (dating to 2008). Polygon rings are CW and holes are CCW,
which is the opposite of the default RFC 7946-compatible output. This should
be rarely needed, though may be useful when preparing data for D3-based
data visualizations (such as \code{plotly::plot_ly()}). Default \code{FALSE}}
  }}
}
\value{
lines in the same class as the input layer, but without attributes
}
\description{
Create a line layer consisting of shared boundaries with no attribute data
}
\examples{
library(geojsonsf)
library(sf)

poly <- structure('{"type":"FeatureCollection",
            "features":[
              {"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,2],[102,3],[103,3],[103,2],[102,2]
                  ]]}}
              ,{"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,3],[104,3],[104,2],[103,2],[103,3]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,1],[102,2],[103,2],[103,1],[102,1]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,1],[103,2],[104,2],[104,1],[103,1]
                  ]]}}]}', class = c("geojson", "json"))

poly <- geojson_sf(poly)
plot(poly)

out <- ms_innerlines(poly)
plot(out)

}
