% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdvcov.r
\name{fitdvcov}
\alias{fitdvcov}
\title{Fitdvcov}
\usage{
fitdvcov(x1, beta1, beta2, vcw)
}
\arguments{
\item{x1}{data}

\item{beta1}{model 1 beta estimate}

\item{beta2}{model 2 beta estimate}

\item{vcw}{variance matrix}
}
\description{
Obtains measurement for the fits based on estimates beta1, beta2 and
covariance matrix from a rank based methods.
}
\examples{


# Compare GR and JR methods

data(schools)

model = y ~ 1 + sex + age + (1 | region) + (1 | region:school)

# Extract covariants into matrix
cov = as.matrix(data.frame(schools[,"sex"], schools[,"age"]))

# Fit the models using each method
jr.fit = rlme(model, schools, method="jr")
gr.fit = rlme(model, schools, method="gr")

# Extract beta estimates, ignoring the intercept
jr.beta = jr.fit$fixed.effects$Estimate[c(2, 3)]
gr.beta = gr.fit$fixed.effects$Estimate[c(2, 3)]

# Extract beta variance matrix
var.b = jr.fit$var.b

fitdvcov(cov, jr.beta, gr.beta, var.b)

}
\seealso{
\code{\link{compare.fits}}
}
