% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkd_get_ads_analytics.R
\name{lkd_get_ads_analytics}
\alias{lkd_get_ads_analytics}
\title{Get Linkedin ads analytics
The Analytics Finder should be used when specifying a single pivot.}
\usage{
lkd_get_ads_analytics(
  pivot = c("COMPANY", "ACCOUNT", "SHARE", "CAMPAIGN", "CREATIVE", "CAMPAIGN_GROUP",
    "CONVERSION", "CONVERSATION_NODE", "CONVERSATION_NODE_OPTION_INDEX",
    "SERVING_LOCATION", "CARD_INDEX", "MEMBER_COMPANY_SIZE", "MEMBER_INDUSTRY",
    "MEMBER_SENIORITY", "MEMBER_JOB_TITLE", "MEMBER_JOB_FUNCTION", "MEMBER_COUNTRY_V2",
    "MEMBER_REGION_V2", "MEMBER_COMPANY"),
  fields = c("pivotValues", "dateRange", "clicks", "impressions", "dateRange",
    "costInUsd", "oneClickLeads", "externalWebsiteConversions"),
  date_from = Sys.Date() - 31,
  date_to = Sys.Date() - 1,
  time_granularity = c("DAILY", "ALL", "MONTHLY", "YEARLY"),
  campaign_type = NULL,
  sort_by_fields = c("", "COST_IN_LOCAL_CURRENCY", "IMPRESSIONS", "ONE_CLICK_LEADS",
    "OPENS", "SENDS", "EXTERNAL_WEBSITE_CONVERSIONS"),
  sort_by_order = c("", "ASCENDING", "DESCENDING"),
  ...
)
}
\arguments{
\item{pivot}{String. Pivot of results, by which each report data point is grouped.
\itemize{
\item COMPANY - Group results by advertiser's company
\item ACCOUNT - Group results by account.
\item SHARE - Group results by sponsored share.
\item CAMPAIGN - Group results by campaign.
\item CREATIVE - Group results by creative.
\item CAMPAIGN_GROUP - Group results by campaign group.
\item CONVERSION - Group results by conversion.
\item CONVERSATION_NODE - The element row in the conversation will be the information for each individual node of the conversation tree.
\item CONVERSATION_NODE_OPTION_INDEX - Used actionClicks are deaggregated and reported at the Node Button level. The second value of the pivot_values will be the index of the button in the node.
\item SERVING_LOCATION - Group results by serving location, onsite or offsite.
\item CARD_INDEX - Group results by the index of where a card appears in a carousel ad creative. Metrics are based on the index of the card at the time when the user's action (impression, click, etc.) happened on the creative (Carousel creatives only).
\item MEMBER_COMPANY_SIZE - Group results by member company size.
\item MEMBER_INDUSTRY - Group results by member industry.
\item MEMBER_SENIORITY - Group results by member seniority.
\item MEMBER_JOB_TITLE - Group results by member job title.
\item MEMBER_JOB_FUNCTION - Group results by member job function.
\item MEMBER_COUNTRY_V2 - Group results by member country.
\item MEMBER_REGION_V2 - Group results by member region.
\item MEMBER_COMPANY - Group results by member company.
\item PLACEMENT_NAME - Group results by placement.
\item IMPRESSION_DEVICE_TYPE - Group results by the device type the ad made an impression on. Reach metrics and conversion metrics will not be available when this pivot is used.
}}

\item{fields}{String vector of report metrics. You can find list of actual metrics \href{https://learn.microsoft.com/en-us/linkedin/marketing/integrations/ads-reporting/ads-reporting?view=li-lms-2023-04&tabs=http#metrics-available}{here}.}

\item{date_from}{Date. Represents the inclusive start time range of the analytics. If unset, it indicates an open range up to the end time.}

\item{date_to}{Date. Represents the inclusive end time range of the analytics. Must be after start time if it's present. If unset, it indicates an open range from start time to everything after.}

\item{time_granularity}{String. Time granularity of results. Valid enum values:
\itemize{
\item ALL - Results grouped into a single result across the entire time range of the report.
\item DAILY - Results grouped by day.
\item MONTHLY - Results grouped by month.
\item YEARLY - Results grouped by year.
}}

\item{campaign_type}{String. Match result by a campaign type. Supported types are: TEXT_AD, SPONSORED_UPDATES, SPONSORED_INMAILS, DYNAMIC. Requires at least one other facet. Defaults to empty.}

\item{sort_by_fields}{String. The field by which the results are sorted. Supported values include:
\itemize{
\item COST_IN_LOCAL_CURRENCY
\item IMPRESSIONS
\item CLICKS
\item ONE_CLICK_LEADS
\item OPENS
\item SENDS
\item EXTERNAL_WEBSITE_CONVERSIONS
}}

\item{sort_by_order}{String. The order of the results. Supported values include:
\itemize{
\item ASCENDING
\item DESCENDING
}}

\item{...}{Faceting parameter For more details see next \href{https://learn.microsoft.com/en-us/linkedin/marketing/integrations/ads-reporting/ads-reporting?view=li-lms-2023-04&tabs=http#query-parameters-4}{link}.You must specify at least one of:
\itemize{
\item shares - Match result by share facets. Defaults to empty.
\item campaigns - Match result by campaign facets. Defaults to empty. For example \code{campaigns = c('urn:li:sponsoredCampaign:253102116', 'urn:li:sponsoredCampaign:276103383')}.
\item creatives - Match result by creative facets. Defaults to empty.
\item campaignGroups - Match result by campaign group facets. Defaults to empty.
\item accounts - Match result by sponsored ad account facets. Defaults to empty. For example \code{accounts = 'urn:li:sponsoredAccount:511009658'}.
\item companies - Match result by company facets. Defaults to empty.
}}
}
\value{
tibble with report
}
\description{
Get Linkedin ads analytics
The Analytics Finder should be used when specifying a single pivot.
}
\examples{
\dontrun{
stat <- lkd_get_ads_analytics(
    pivot            = 'CAMPAIGN',
    date_from        = '2023-09-01',
    date_to          = '2023-09-30',
    time_granularity = 'DAILY',
    fields           = c(
      'pivotValues',
      'dateRange',
      'clicks',
      'impressions',
      'dateRange',
      'costInUsd',
      'oneClickLeads',
      'externalWebsiteConversions'
    ),
    accounts  = 'urn:li:sponsoredAccount:511009658',
    campaigns = c(
      'urn:li:sponsoredCampaign:253102116',
      'urn:li:sponsoredCampaign:276103383'
    )
 )
}
}
