% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxmatching.R
\name{MaxMatching}
\alias{MaxMatching}
\title{Solver for Maximum Weighted Matching}
\usage{
MaxMatching(
  arcSources,
  arcTargets,
  arcWeights = NULL,
  numNodes,
  algorithm = "MaxWeightedMatching"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's edges.
Default is \code{NULL} for unweight matching.}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "MaxWeightedMatching",
"MaxWeightedPerfectMatching", "MaxWeightedFractionalMatching", and
"MaxWeightedPerfectFractionalMatching". "MaxWeightedMatching" is the
default.}
}
\value{
A named list containing two entries: 1) "value": the matching value,
  2) "edges": the edges of the final graph, in a list of (node, node) pairs
}
\description{
Finds the maximum weighted matching in graphs and bipartite graphs. Each
algorithm in this set returns different outputs depending on different
situations, like PerfectMatching or PerfectFractionalMathing.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00615.html}.
}
