% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition.R, R/generics.R
\name{sadecomposition}
\alias{sadecomposition}
\alias{print.JD3_SADECOMPOSITION}
\alias{plot.JD3_SADECOMPOSITION}
\alias{sa_decomposition}
\title{Generic Function for Seasonal Adjustment Decomposition}
\usage{
sadecomposition(y, sa, t, s, i, mul)

\method{print}{JD3_SADECOMPOSITION}(x, n_last_obs = frequency(x$series), ...)

\method{plot}{JD3_SADECOMPOSITION}(
  x,
  first_date = NULL,
  last_date = NULL,
  type_chart = c("sa-trend", "seas-irr"),
  caption = c(`sa-trend` = "Y, Sa, trend", `seas-irr` = "Sea., irr.")[type_chart],
  colors = c(y = "#F0B400", t = "#1E6C0B", sa = "#155692", s = "#1E6C0B", i = "#155692"),
  ...
)

sa_decomposition(x, ...)
}
\arguments{
\item{y, sa, t, s, i, mul}{seasonal adjustment decomposition parameters.}

\item{x}{the object to print.}

\item{n_last_obs}{number of observations to print (by default equal to the frequency of the series).}

\item{...}{further arguments.}

\item{first_date, last_date}{first and last date to plot (by default all the data is used).}

\item{type_chart}{the chart to plot: \code{"sa-trend"} (by default) plots the input time series,
the seasonally adjusted and the trend; \code{"seas-irr"} plots the seasonal and the irregular components.}

\item{caption}{the caption of the plot.}

\item{colors}{the colours used in the plot.}
}
\value{
\code{"JD3_SADECOMPOSITION"} object.
}
\description{
Generic function to format the seasonal adjustment decomposition components.
\code{sa_decomposition()} is a generic function defined in other packages.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
decompo <- sadecomposition(
    y = ts(c(112, 118, 132, 129, 121, 135), start = 2000, frequency = 12L),
    sa = ts(c(121.72, 124.52, 125.4, 128.91, 128.84, 126.73), start = 2000, frequency = 12L),
    t = ts(c(122.24, 124.33, 126.21, 127.61, 127.8, 126.94), start = 2000, frequency = 12L),
    s = ts(c(0.92, 0.95, 1.05, 1, 0.94, 1.07), start = 2000, frequency = 12L),
    i = ts(c(1, 1, 0.99, 1.01, 1.01, 1), start = 2000, frequency = 12L),
    mul = TRUE
)
print(decompo)
plot(decompo)
\dontshow{\}) # examplesIf}
}
