% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ramp_variable}
\alias{ramp_variable}
\title{Ramp regressor}
\usage{
ramp_variable(frequency, start, length, s, range)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{range}{the range of the regressor. A vector of length 2 containing the datesin the format \code{"YYYY-MM-DD"}
or the position in the series, in number of periods from counting from the series start.}
}
\value{
a \code{ts} object
}
\description{
Ramp regressor
}
\details{
A ramp between two dates \eqn{t_0} and \eqn{t_1} is defined as:
\deqn{RP_t=
\begin{cases}
-1 & \text{if }t\geq t_0 \\
\frac{t-t_0}{t_1-t_0}-1 & t_0< t < t_1 \\
0 & t \leq t_1
\end{cases}
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Ramp variable from January 2001 to September 2001
rp <- ramp_variable(12, c(2000, 1), length = 12 * 4, range = c(13, 21))
# Or equivalently
rp <- ramp_variable(12, c(2000, 1), length = 12 * 4, range = c("2001-01-01", "2001-09-02"))
plot.ts(rp)
\dontshow{\}) # examplesIf}
}
