/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.modelling;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdplus.sa.base.api.ComponentType;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ICalendarVariable;
import jdplus.toolkit.base.api.timeseries.regression.IMovingHolidayVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicDummies;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.SwitchOutlier;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.TrigonometricVariables;

public class SaVariablesMapping {
    private static final Map<Class<? extends ITsVariable>, VariableMapping> DEFAULTMAPPING;
    private final Map<ITsVariable, ComponentType> mapping = new HashMap<ITsVariable, ComponentType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends ITsVariable> boolean register(Class<V> wclass, VariableMapping<V> mapping) {
        Map<Class<? extends ITsVariable>, VariableMapping> map = DEFAULTMAPPING;
        synchronized (map) {
            if (DEFAULTMAPPING.containsKey(wclass)) {
                return false;
            }
            DEFAULTMAPPING.put(wclass, mapping);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V extends ITsVariable> boolean put(Class<V> wclass, VariableMapping<V> factory) {
        Map<Class<? extends ITsVariable>, VariableMapping> map = DEFAULTMAPPING;
        synchronized (map) {
            if (DEFAULTMAPPING.containsKey(wclass)) {
                return false;
            }
            DEFAULTMAPPING.put(wclass, factory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends ITsVariable> boolean unregister(Class<V> vclass) {
        Map<Class<? extends ITsVariable>, VariableMapping> map = DEFAULTMAPPING;
        synchronized (map) {
            VariableMapping removed = DEFAULTMAPPING.remove(vclass);
            return removed != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentType defaultMapping(ITsVariable var) {
        Map<Class<? extends ITsVariable>, VariableMapping> map = DEFAULTMAPPING;
        synchronized (map) {
            VariableMapping m = DEFAULTMAPPING.get(var.getClass());
            if (m != null) {
                return m.map(var);
            }
            m = this.deepSearch(var.getClass());
            if (m != null) {
                return m.map(var);
            }
            return ComponentType.Undefined;
        }
    }

    private VariableMapping deepSearch(Class t) {
        VariableMapping m;
        int i;
        if (t == ITsVariable.class) {
            return null;
        }
        Class<?>[] interfaces = t.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            m = DEFAULTMAPPING.get(interfaces[i]);
            if (m == null) continue;
            return m;
        }
        for (i = 0; i < interfaces.length; ++i) {
            m = this.deepSearch(interfaces[i]);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public void addDefault(ITsVariable ... vars) {
        for (ITsVariable var : vars) {
            this.mapping.put(var, this.defaultMapping(var));
        }
    }

    public void put(SaVariablesMapping other) {
        this.mapping.putAll(other.mapping);
    }

    public void put(ITsVariable var, ComponentType type) {
        this.mapping.put(var, type);
    }

    public void clear() {
        this.mapping.clear();
    }

    public void remove(ITsVariable var) {
        this.mapping.remove(var);
    }

    public Map<ITsVariable, ComponentType> mapping() {
        return Collections.unmodifiableMap(this.mapping);
    }

    public ITsVariable[] forComponentType(ComponentType type) {
        ArrayList vars = new ArrayList();
        this.mapping.forEach((var, vtype) -> {
            if (type == vtype) {
                vars.add(var);
            }
        });
        return (ITsVariable[])vars.toArray(ITsVariable[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Class<? extends ITsVariable>, VariableMapping> map = DEFAULTMAPPING = new HashMap<Class<? extends ITsVariable>, VariableMapping>();
        synchronized (map) {
            DEFAULTMAPPING.put(AdditiveOutlier.class, v -> ComponentType.Irregular);
            DEFAULTMAPPING.put(LevelShift.class, v -> ComponentType.Trend);
            DEFAULTMAPPING.put(TransitoryChange.class, v -> ComponentType.Irregular);
            DEFAULTMAPPING.put(SwitchOutlier.class, v -> ComponentType.Irregular);
            DEFAULTMAPPING.put(PeriodicOutlier.class, v -> ComponentType.Seasonal);
            DEFAULTMAPPING.put(ICalendarVariable.class, v -> ComponentType.CalendarEffect);
            DEFAULTMAPPING.put(IMovingHolidayVariable.class, v -> ComponentType.CalendarEffect);
            DEFAULTMAPPING.put(Ramp.class, v -> ComponentType.Trend);
            SaVariablesMapping.put(InterventionVariable.class, var -> {
                if (var.getDeltaSeasonal() > 0.0 && var.getDelta() > 0.0) {
                    return ComponentType.Undefined;
                }
                List sequences = var.getSequences();
                int maxseq = 0;
                for (Range seq : sequences) {
                    int len = (int)((LocalDateTime)seq.start()).until((Temporal)((Object)seq.end()), ChronoUnit.DAYS) / 365;
                    if (len <= maxseq) continue;
                    maxseq = len;
                }
                if (maxseq > 0) {
                    return var.getDeltaSeasonal() == 0.0 ? ComponentType.Trend : ComponentType.Undefined;
                }
                if (var.getDeltaSeasonal() > 0.0) {
                    return ComponentType.Seasonal;
                }
                if (var.getDelta() > 0.8) {
                    return ComponentType.Trend;
                }
                return ComponentType.Irregular;
            });
            DEFAULTMAPPING.put(PeriodicDummies.class, v -> ComponentType.Seasonal);
            DEFAULTMAPPING.put(PeriodicContrasts.class, v -> ComponentType.Seasonal);
            DEFAULTMAPPING.put(TrigonometricVariables.class, v -> ComponentType.Seasonal);
        }
    }

    @FunctionalInterface
    public static interface VariableMapping<V> {
        public ComponentType map(V var1);
    }
}

