/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.html;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.xml.Stax;
import standalone_spreadsheet.nbbrd.io.xml.Xml;

final class HtmlBookWriter {
    private static final String STYLE = HtmlBookWriter.getStyleContent();
    private final XMLOutputFactory xof;
    @Deprecated
    private DateFormat dateFormat;
    @Deprecated
    private NumberFormat numberFormat;
    private Charset charset;

    HtmlBookWriter(@NonNull XMLOutputFactory xof) {
        this.xof = Objects.requireNonNull(xof);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        this.numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        this.numberFormat.setMaximumFractionDigits(9);
        this.numberFormat.setMaximumIntegerDigits(12);
        this.charset = StandardCharsets.UTF_8;
    }

    @Deprecated
    public void setDateFormat(@NonNull DateFormat dateFormat) {
        this.dateFormat = Objects.requireNonNull(dateFormat);
    }

    @Deprecated
    public void setNumberFormat(@NonNull NumberFormat numberFormat) {
        this.numberFormat = Objects.requireNonNull(numberFormat);
    }

    public void setCharset(@NonNull Charset charset) {
        this.charset = Objects.requireNonNull(charset);
    }

    public void write(@NonNull Book book, @NonNull OutputStream stream) throws IOException {
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        this.getFormatter().formatStream(book, stream);
    }

    public void write(@NonNull Book book, @NonNull Writer writer) throws IOException {
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        this.getFormatter().formatWriter(book, writer);
    }

    @NonNull
    public String writeToString(@NonNull Book book) throws IOException {
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        return this.getFormatter().formatToString(book);
    }

    private Xml.Formatter<Book> getFormatter() {
        return Stax.StreamFormatter.builder().factory(() -> this.xof).encoding(this.charset).handler(this::writeHtml).build();
    }

    private void writeHtml(Book book, XMLStreamWriter w) throws XMLStreamException, IOException {
        BasicHtmlWriter f = new BasicHtmlWriter(w);
        f.beginHtml();
        f.beginHead();
        f.writeStyle(STYLE);
        f.endHead();
        f.beginBody();
        int sheetCount = book.getSheetCount2();
        for (int s = 0; s < sheetCount; ++s) {
            this.writeTable(f, book.getSheet(s));
        }
        f.endBody();
        f.endHtml();
    }

    private void writeTable(BasicHtmlWriter f, Sheet sheet) throws XMLStreamException {
        f.beginTable(sheet.getName(), "sheet");
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            f.beginRow();
            for (int j = 0; j < columnCount; ++j) {
                Object cellValue = sheet.getCellValue(i, j);
                if (cellValue != null) {
                    if (cellValue instanceof Date) {
                        f.writeCell(this.dateFormat.format((Date)cellValue), false, "type-date");
                        continue;
                    }
                    if (cellValue instanceof Number) {
                        f.writeCell(this.numberFormat.format(((Number)cellValue).doubleValue()), false, "type-number");
                        continue;
                    }
                    if (!(cellValue instanceof String)) continue;
                    f.writeCell((String)cellValue, false, "");
                    continue;
                }
                f.writeCell("", false, "");
            }
            f.endRow();
        }
        f.endTable();
    }

    private static String getStyleContent() {
        String string;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(HtmlBookWriter.class.getResourceAsStream("/BasicStyle.css"), StandardCharsets.UTF_8));
        try {
            string = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        buffer.close();
        return string;
    }

    private static final class BasicHtmlWriter {
        private final XMLStreamWriter writer;

        public BasicHtmlWriter(XMLStreamWriter writer) {
            this.writer = writer;
        }

        public void beginHtml() throws XMLStreamException {
            this.writer.writeStartDocument();
            this.writer.writeStartElement("html");
        }

        public void endHtml() throws XMLStreamException {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.flush();
        }

        public void beginHead() throws XMLStreamException {
            this.writer.writeStartElement("head");
            this.writer.writeEmptyElement("meta");
            this.writer.writeAttribute("charset", "utf-8");
        }

        public void endHead() throws XMLStreamException {
            this.writer.writeEndElement();
        }

        public void writeStyle(String content) throws XMLStreamException {
            this.writer.writeStartElement("style");
            this.writer.writeAttribute("media", "screen");
            this.writer.writeAttribute("type", "text/css");
            this.writer.writeCharacters(content);
            this.writer.writeEndElement();
        }

        public void beginBody() throws XMLStreamException {
            this.writer.writeStartElement("body");
        }

        public void endBody() throws XMLStreamException {
            this.writer.writeEndElement();
        }

        public void writeCaption(String text) throws XMLStreamException {
            this.writer.writeStartElement("caption");
            this.writer.writeCharacters(text);
            this.writer.writeEndElement();
        }

        public void beginTable(String name, String style) throws XMLStreamException {
            this.writer.writeStartElement("table");
            if (!name.isEmpty()) {
                this.writer.writeAttribute("id", name);
            }
            if (!style.isEmpty()) {
                this.writer.writeAttribute("class", style);
            }
            this.writeCaption(name);
        }

        public void endTable() throws XMLStreamException {
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void beginRow() throws XMLStreamException {
            this.writer.writeStartElement("tr");
        }

        public void endRow() throws XMLStreamException {
            this.writer.writeEndElement();
        }

        public void writeCell(CharSequence characters, boolean header, String style) throws XMLStreamException {
            if (characters.length() > 0) {
                this.writer.writeStartElement(header ? "th" : "td");
                if (!style.isEmpty()) {
                    this.writer.writeAttribute("class", style);
                }
                this.writer.writeCharacters(characters.toString());
                this.writer.writeEndElement();
            } else {
                this.writer.writeEmptyElement(header ? "th" : "td");
                if (!style.isEmpty()) {
                    this.writer.writeAttribute("class", style);
                }
            }
        }
    }
}

