/*
 * Decompiled with CFR 0.152.
 */
package jdplus.text.base.api;

import internal.text.base.api.TxtDataDisplayName;
import internal.text.base.api.TxtFileFilter;
import internal.text.base.api.TxtLegacyMoniker;
import internal.text.base.api.TxtLoader;
import internal.text.base.api.TxtParam;
import internal.text.base.api.TxtSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jdplus.text.base.api.TxtBean;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceListener;
import jdplus.toolkit.base.tsp.FileLoader;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.HasDataSourceBean;
import jdplus.toolkit.base.tsp.HasDataSourceMutableList;
import jdplus.toolkit.base.tsp.HasFilePaths;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.stream.TsStreamAsProvider;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.FallbackDataMoniker;
import jdplus.toolkit.base.tsp.util.ImmutableValueFactory;
import jdplus.toolkit.base.tsp.util.ImmutableValuePool;
import lombok.Generated;
import lombok.NonNull;

public final class TxtProvider
implements FileLoader<TxtBean> {
    public static final String NAME = "Txt";
    private final HasDataSourceMutableList mutableListSupport;
    private final HasDataMoniker monikerSupport;
    private final HasDataSourceBean<TxtBean> beanSupport;
    private final HasFilePaths filePathSupport;
    private final HasDataDisplayName displayNameSupport;
    private final TxtSupport txtSupport;
    private final TsProvider tsSupport;
    private final TxtFileFilter fileFilter;

    public TxtProvider() {
        TxtParam.V1 param = new TxtParam.V1();
        ImmutableValuePool pool = ImmutableValuePool.of();
        this.mutableListSupport = HasDataSourceMutableList.of((String)NAME, arg_0 -> ((ImmutableValuePool)pool).remove(arg_0));
        this.monikerSupport = FallbackDataMoniker.of((HasDataMoniker)HasDataMoniker.usingUri((String)NAME), (HasDataMoniker)TxtLegacyMoniker.of(NAME, param));
        this.beanSupport = HasDataSourceBean.of((String)NAME, (DataSource.Converter)param, (String)param.getVersion());
        this.filePathSupport = HasFilePaths.of(() -> ((ImmutableValuePool)pool).clear());
        this.displayNameSupport = TxtDataDisplayName.of(NAME, param, arg_0 -> ((ImmutableValuePool)pool).peek(arg_0));
        this.txtSupport = TxtSupport.of(NAME, (ImmutableValueFactory<TsCollection>)pool.asFactory(dataSource -> TxtProvider.getData(dataSource, this.filePathSupport, param)), (DataSetConversion<TsCollection, Integer>)((DataSetConversion)ignore -> param.getSeriesParam()));
        this.tsSupport = TsStreamAsProvider.of((String)NAME, (HasTsStream)this.txtSupport, (HasDataMoniker)this.monikerSupport, () -> ((ImmutableValuePool)pool).clear());
        this.fileFilter = new TxtFileFilter();
    }

    @NonNull
    public String getDisplayName() {
        return "Txt files";
    }

    @NonNull
    private static TsCollection getData(@NonNull DataSource dataSource, HasFilePaths paths, TxtParam param) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return TxtLoader.load((TxtBean)param.get(dataSource), paths);
    }

    @Generated
    public boolean open(DataSource arg0) throws IllegalArgumentException {
        return this.mutableListSupport.open(arg0);
    }

    @Generated
    public boolean close(DataSource arg0) throws IllegalArgumentException {
        return this.mutableListSupport.close(arg0);
    }

    @Generated
    public void closeAll() {
        this.mutableListSupport.closeAll();
    }

    @Generated
    public void reload(DataSource arg0) throws IllegalArgumentException {
        this.mutableListSupport.reload(arg0);
    }

    @Generated
    public List<DataSource> getDataSources() {
        return this.mutableListSupport.getDataSources();
    }

    @Generated
    public void addDataSourceListener(DataSourceListener arg0) {
        this.mutableListSupport.addDataSourceListener(arg0);
    }

    @Generated
    public void removeDataSourceListener(DataSourceListener arg0) {
        this.mutableListSupport.removeDataSourceListener(arg0);
    }

    @Generated
    public TsMoniker toMoniker(DataSource arg0) throws IllegalArgumentException {
        return this.monikerSupport.toMoniker(arg0);
    }

    @Generated
    public TsMoniker toMoniker(DataSet arg0) throws IllegalArgumentException {
        return this.monikerSupport.toMoniker(arg0);
    }

    @Generated
    public Optional<DataSource> toDataSource(TsMoniker arg0) throws IllegalArgumentException {
        return this.monikerSupport.toDataSource(arg0);
    }

    @Generated
    public Optional<DataSet> toDataSet(TsMoniker arg0) throws IllegalArgumentException {
        return this.monikerSupport.toDataSet(arg0);
    }

    @Generated
    public TxtBean newBean() {
        return (TxtBean)this.beanSupport.newBean();
    }

    @Generated
    public DataSource encodeBean(Object arg0) throws IllegalArgumentException {
        return this.beanSupport.encodeBean(arg0);
    }

    @Generated
    public TxtBean decodeBean(DataSource arg0) throws IllegalArgumentException {
        return (TxtBean)this.beanSupport.decodeBean(arg0);
    }

    @Generated
    public void setPaths(File[] arg0) {
        this.filePathSupport.setPaths(arg0);
    }

    @Generated
    public File[] getPaths() {
        return this.filePathSupport.getPaths();
    }

    @Generated
    public File resolveFilePath(File file) throws FileNotFoundException {
        return this.filePathSupport.resolveFilePath(file);
    }

    @Generated
    public String getDisplayName(DataSource arg0) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(arg0);
    }

    @Generated
    public String getDisplayName(DataSet arg0) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(arg0);
    }

    @Generated
    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayNodeName(dataSet);
    }

    @Generated
    public String getDisplayName(IOException exception) throws IllegalArgumentException {
        return this.displayNameSupport.getDisplayName(exception);
    }

    @Generated
    public List<DataSet> children(DataSource arg0) throws IllegalArgumentException, IOException {
        return this.txtSupport.children(arg0);
    }

    @Generated
    public List<DataSet> children(DataSet arg0) throws IllegalArgumentException, IOException {
        return this.txtSupport.children(arg0);
    }

    @Generated
    public void clearCache() {
        this.tsSupport.clearCache();
    }

    @Generated
    public void close() {
        this.tsSupport.close();
    }

    @Generated
    public TsCollection getTsCollection(TsMoniker arg0, TsInformationType arg1) throws IOException, IllegalArgumentException {
        return this.tsSupport.getTsCollection(arg0, arg1);
    }

    @Generated
    public Ts getTs(TsMoniker arg0, TsInformationType arg1) throws IOException, IllegalArgumentException {
        return this.tsSupport.getTs(arg0, arg1);
    }

    @Generated
    public String getSource() {
        return this.tsSupport.getSource();
    }

    @Generated
    public boolean isAvailable() {
        return this.tsSupport.isAvailable();
    }

    @Generated
    public boolean accept(File pathname) {
        return this.fileFilter.accept(pathname);
    }

    @Generated
    public String getFileDescription() {
        return this.fileFilter.getFileDescription();
    }
}

