% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{get_rif_interquantile_range}
\alias{get_rif_interquantile_range}
\title{Estimate RIF of interquantile range}
\usage{
get_rif_interquantile_range(dep_var, weights, probs, ...)
}
\arguments{
\item{dep_var}{dependent variable of distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.
The default (\code{NULL)} is equivalent to \code{weights = rep(1, length(dep_var))}.}

\item{probs}{a vector of length 2 with probabilities corresponding to the limits of the interquantile range of interest.
The interquantile range is defined as difference between the quantile with the larger probability and the one
with the lower probability.}

\item{...}{further arguments passed on to \link[stats]{density}.}
}
\value{
A data frame with one column containing the RIF of the interquantile range for each observation and one column containing the weights.
}
\description{
Compute the recentered influence function (RIF) of a weighted
interquantile range.
}
\examples{

set.seed(123)
dep_var <- rlnorm(100)
weights <- rep(1, 100)
get_rif_interquantile_range(dep_var, probs = c(0.1, 0.9), weights = weights)

}
\references{
Firpo, Sergio P., Nicole M. Fortin, and Thomas Lemieux. 2018. “Decomposing Wage Distributions Using Recentered
Influence Function Regressions.” \emph{Econometrics} 6(2), 28.
}
