% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{cluster_dot}
\alias{cluster_dot}
\title{Cluster-level Dot Plot of Enrichment Significance}
\usage{
cluster_dot(cluster_result, clusters = NULL, value_type = "Padj", title = NULL)
}
\arguments{
\item{cluster_result}{A result list returned from \code{\link{cluster}}.}

\item{clusters}{Optional numeric vector of cluster IDs to include. Defaults to all clusters.}

\item{value_type}{The name of the value column to visualize (e.g., "Padj" or "Pvalue").}

\item{title}{Optional title for the plot. If NULL, a default title is generated.}
}
\value{
A \code{plotly} object representing the dot plot.
}
\description{
Creates a dot plot summarizing cluster-level enrichment across datasets.
Each point represents a cluster, with its size proportional to the number
of terms and its x-position reflecting average significance (e.g., Padj or Pvalue).
}
\examples{
\donttest{
# Load example data
cluster_result <- readRDS(system.file("extdata", "cluster_result.rds",
                                      package = "richCluster"))
cdot <- cluster_dot(cluster_result)
cdot
}
}
