% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_ops.R
\name{asym}
\alias{asym}
\title{Antisymmetric tensor part}
\usage{
asym(x, ...)
}
\arguments{
\item{x}{A labeled tensor object, created by \code{\link{\%_\%}} or \code{\link[=tensor]{tensor()}}.}

\item{...}{Any number of index expressions. The indices need to occur
in \code{x}.}
}
\value{
A modified tensor object.
}
\description{
Takes the antisymmetric tensor part of a tensor \code{x} with respect to the
specified indices \code{...}.
An error is thrown if the specified indices do not exist.
}
\examples{
a <- array(1:4, dim = c(2, 2))
a \%_\% .(i, j) |> asym(i, j)
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Ricci_calculus#Symmetric_and_antisymmetric_parts}{Ricci calculus - Symmetric and antisymmetric parts}

Other tensor operations: 
\code{\link{Ops.tensor}()},
\code{\link{kron}()},
\code{\link{l}()},
\code{\link{r}()},
\code{\link{subst}()},
\code{\link{sym}()}
}
\concept{sym}
\concept{tensor operations}
