% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biperiodogram.R
\name{biperiodogram}
\alias{biperiodogram}
\title{Calculate biperiodogram}
\usage{
biperiodogram(
  x,
  dft_given = FALSE,
  mc = FALSE,
  mc_cores = getOption("mc.cores", 2L)
)
}
\arguments{
\item{x}{Given time series (or its DFT), as a data frame or matrix with
which columns correspond to sampled stretches}

\item{dft_given}{If TRUE, suppose that DFTs are given instead of time series
data and skip the fast fourier transform. Default: \code{FALSE}.}

\item{mc}{If \code{TRUE}, calculation is done in parallel computation.
Defaults to \code{FALSE}.}

\item{mc_cores}{The number of cores in use for parallel computation, passed
\code{\link[parallel:mclapply]{parallel::mcmapply}()} etc. as \code{mc.cores}.}
}
\value{
A list with names
\describe{
\item{f1:}{
The first elements of frequency pairs.
}
\item{f2:}{
The second elements of frequency pairs.
}
\item{value:}{
The biperiodogram as a matrix.
Each of its rows is for a frequency pair; its columns correspond to stretches.
}
}
}
\description{
Calculate the biperiodogram of real-valued time series
}
\examples{
f <- function(x) {
    sin(2 * x) + sin(3 * x + 1) + sin(2 * x) * sin(3 * x + 1)
}
v <- sapply(seq_len(1280), f) + rnorm(1280)
m <- matrix(v, nrow = 128)
bp <- biperiodogram(m)

m2 <- stats::mvfft(m)
bp2 <- biperiodogram(m2, dft_given = TRUE)

}
\references{
Hinich, M.J., 1994. Higher order cumulants and cumulant spectra. Circuits Systems and Signal Process 13, 391–402. doi:10.1007/BF01183737
}
