% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft_spectro.R
\name{fft_spectro}
\alias{fft_spectro}
\title{fft_spectro}
\usage{
fft_spectro(x, f_out = 80, window_size = 256, padding = 2048, plot = TRUE)
}
\arguments{
\item{x}{a `tuneR` "Wave" object or the path to a .wav file.}

\item{f_out}{the sample frequency for the output}

\item{window_size}{number of samples to calculate each spectrum over}

\item{padding}{length to zero pad signal to. If signal is longer than padding, this will be increased.}

\item{plot}{if true a spectrogram will be plotted}
}
\value{
Returns a tibble with frequency (Hz), time (s) and power
}
\description{
Calculates low frequency power spectrogram of vocalic interval of speech signal. Following method of Tilsen & Johnson (2008)
}
\references{
Tilsen, S., & Johnson, K. (2008). Low-frequency Fourier analysis of speech rhythm. The Journal of the Acoustical Society of America, 124(2), EL34–EL39. doi:10.1121/1.2947626
}
\seealso{
fft_spectrum
}
