% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resumiR.R
\name{s_simple}
\alias{s_simple}
\title{Medidas de resumen univariadas en series numéricas simples}
\usage{
s_simple(
  x,
  decimales = 1,
  recorte = 0.1,
  percentiles = c(0.25, 0.5, 0.75),
  boxplot = FALSE,
  ...
)
}
\arguments{
\item{x}{vector numérico de tipo *integer* o *numeric* (puede incluir NA's o valores infinitos).}

\item{decimales}{el número de posiciones decimales de los resultados; por defecto es 1.}

\item{recorte}{proporción de recorte unilateral de la serie ordenada para la estimación de la media recortada; el máximo valor admitido es 0.25;  por defecto 0.1.}

\item{percentiles}{vector numérico de probabilidades acumuladas para el cálculo de percentiles; por defecto \{0.25, 0.5, 0.75\}}

\item{boxplot}{lógico; si es verdadero (TRUE), devuelve el gráfico de cajas de la serie; hereda propiedades de ggplot; por defecto es FALSE.}

\item{...}{argumentos que heredan de la función boxplot()}
}
\value{
devuelve un objeto de tipo tibble con una serie de medidas de resumen; si el argumento boxplot=TRUE, devuelve un gráfico de cajas que hereda propiedades de ggplot().
}
\description{
Devuelve medidas de resumen univariadas de los datos numéricos ingresados, discretos o continuos, como series simples. Permite graficar la serie por medio de un gráfico de cajas y bigotes.
}
\examples{
library(resumiR)
# Ejemplo
x = iris[[1]]
s_simple(x, decimales = 2, recorte = 0.05, boxplot = TRUE)
}
